/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import noppes.npcs.client.model.ModelNpcAlt;
import noppes.npcs.client.model.ModelRendererAlt;
import noppes.npcs.client.model.animation.AnimationStack;
import noppes.npcs.client.model.part.head.ModelHeadwear;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.CustomArmor;
import org.lwjgl.opengl.GL11;

public class ModelBipedAlt
extends ModelNpcAlt {
    private final boolean isArmorModel;
    private float armorColorR = 1.0f;
    private float armorColorG = 1.0f;
    private float armorColorB = 1.0f;
    public final AnimationStack rightStackData = new AnimationStack(7);
    public final AnimationStack leftStackData = new AnimationStack(6);
    protected EntityEquipmentSlot slot;

    public ModelBipedAlt(float modelSize, boolean isArmorModelIn, boolean smallArmsIn, boolean isClassicPlayer) {
        super(modelSize, smallArmsIn, isClassicPlayer);
        this.isArmorModel = isArmorModelIn;
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.init(modelSize);
    }

    @Override
    protected void init(float modelSize) {
        float handWidth = this.smallArmsIn ? 3.0f : 4.0f;
        this.field_78116_c = new ModelRendererAlt((ModelBase)this, EnumParts.HEAD, 0, 0, true);
        ((ModelRendererAlt)this.field_78116_c).setBox(-4.0f, -8.0f, -4.0f, 8.0f, 3.0f, 3.0f, 2.0f, 8.0f, modelSize);
        this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178720_f = new ModelRendererAlt((ModelBase)this, EnumParts.HEAD, 32, 0, true);
        ((ModelRendererAlt)this.field_178720_f).setBox(-4.0f, -8.0f, -4.0f, 8.0f, 3.0f, 3.0f, 2.0f, 8.0f, modelSize + 0.5f);
        this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
        this.bipedHeadwear_64 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 64, false);
        this.bipedHeadwear_128 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 128, false);
        this.bipedHeadwear_256 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 256, false);
        this.bipedHeadwear_512 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 512, false);
        this.bipedHeadwear_1024 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 1024, false);
        this.bipedHeadwear_2048 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 2048, false);
        this.bipedHeadwear_4096 = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 4096, false);
        this.bipedHeadwear_64_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 64, true);
        this.bipedHeadwear_128_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 128, true);
        this.bipedHeadwear_256_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 256, true);
        this.bipedHeadwear_512_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 512, true);
        this.bipedHeadwear_1024_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 1024, true);
        this.bipedHeadwear_2048_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 2048, true);
        this.bipedHeadwear_4096_old = new ModelHeadwear((ModelBase)this, EnumParts.HEAD, 32, 0, 4096, true);
        this.field_78115_e = new ModelRendererAlt((ModelBase)this, EnumParts.BODY, 16, 16, false);
        ((ModelRendererAlt)this.field_78115_e).setBox(-4.0f, 0.0f, -2.0f, 8.0f, 5.5f, 4.0f, 2.5f, 4.0f, modelSize);
        this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_178723_h = new ModelRendererAlt((ModelBase)this, EnumParts.ARM_RIGHT, 40, 16, false);
        ((ModelRendererAlt)this.field_178723_h).setBox(this.smallArmsIn ? -2.0f : -3.0f, -2.0f, -2.0f, handWidth, 5.5f, 3.5f, 3.0f, 4.0f, modelSize);
        this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        ((ModelRendererAlt)this.field_178723_h).smallArms = this.smallArmsIn;
        ((ModelRendererAlt)this.field_178723_h).isArmor = true;
        this.field_178721_j = new ModelRendererAlt((ModelBase)this, EnumParts.LEG_RIGHT, 0, 16, false);
        ((ModelRendererAlt)this.field_178721_j).setBox(-2.0f, 0.0f, -2.1f, 4.0f, 5.5f, 3.5f, 3.0f, 4.0f, modelSize);
        this.field_178721_j.func_78793_a(-2.0f, 12.0f, 0.0f);
        ((ModelRendererAlt)this.field_178721_j).isArmor = true;
        this.field_178724_i = new ModelRendererAlt((ModelBase)this, EnumParts.ARM_LEFT, 40, 16, false);
        this.field_178724_i.field_78809_i = true;
        ((ModelRendererAlt)this.field_178724_i).setBox(-1.0f, -2.0f, -2.0f, handWidth, 5.5f, 3.5f, 3.0f, 4.0f, modelSize);
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        ((ModelRendererAlt)this.field_178724_i).smallArms = this.smallArmsIn;
        ((ModelRendererAlt)this.field_178724_i).isArmor = true;
        this.field_178722_k = new ModelRendererAlt((ModelBase)this, EnumParts.LEG_LEFT, 0, 16, false);
        this.field_178722_k.field_78809_i = true;
        ((ModelRendererAlt)this.field_178722_k).setBox(-2.2f, 0.0f, -2.1f, 4.0f, 5.5f, 3.5f, 3.0f, 4.0f, modelSize);
        this.field_178722_k.func_78793_a(2.0f, 12.0f, 0.0f);
        ((ModelRendererAlt)this.field_178722_k).isArmor = true;
    }

    @Override
    public void func_78088_a(@Nonnull Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack stack;
        if (entityIn.equals((Object)ModelNpcAlt.editAnimDataSelect.displayNpc) && !ModelNpcAlt.editAnimDataSelect.showArmor) {
            return;
        }
        if (entityIn.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        Map<Object, Object> ba = new HashMap();
        Map<Object, Object> baArmor = new HashMap();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (this.isArmorModel) {
            r = this.armorColorR;
            g = this.armorColorG;
            b = this.armorColorB;
        }
        if (entityIn instanceof EntityPlayer) {
            PlayerData data = PlayerData.get((EntityPlayer)entityIn);
            if (data != null) {
                ba = data.animation.showParts;
                baArmor = data.animation.showArmorParts;
            }
        } else if (entityIn instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)entityIn;
            ba = npc.animation.showParts;
            baArmor = npc.animation.showArmorParts;
            if (!this.isArmorModel && npc.display.getTint() != 0xFFFFFF) {
                r = (float)(npc.display.getTint() >> 16 & 0xFF) / 255.0f;
                g = (float)(npc.display.getTint() >> 8 & 0xFF) / 255.0f;
                b = (float)(npc.display.getTint() & 0xFF) / 255.0f;
            }
        }
        int entitySkinTextureID = GL11.glGetInteger((int)32873);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        boolean bl = this.field_78116_c.field_78806_j = (Boolean)ba.get((Object)EnumParts.HEAD) != false && (!this.isArmorModel || (Boolean)baArmor.get((Object)EnumParts.HEAD) != false && this.slot == EntityEquipmentSlot.HEAD);
        if (this.field_78116_c.field_78806_j && entityIn instanceof EntityLivingBase) {
            ((ModelRendererAlt)this.field_78116_c).checkBacklightColor(r, g, b);
            if (this.field_78091_s) {
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
                if (this.renderHead((EntityLivingBase)entityIn, scale)) {
                    GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
                    this.renderHeadWear(scale);
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            } else {
                if (entityIn.func_70093_af()) {
                    boolean chest = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemArmor;
                    boolean legs = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemArmor;
                    boolean feet = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemArmor;
                    GlStateManager.func_179109_b((float)0.0f, (float)(-0.2f - (legs ? 0.2f : 0.0f) - (feet ? 0.2f : 0.0f) - (chest ? 0.2f : 0.0f)), (float)0.0f);
                }
                if (this.renderHead((EntityLivingBase)entityIn, scale)) {
                    GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
                    this.renderHeadWear(scale);
                }
            }
        }
        this.field_178723_h.field_78806_j = (Boolean)ba.get((Object)EnumParts.ARM_RIGHT) != false && (!this.isArmorModel || (Boolean)baArmor.get((Object)EnumParts.ARM_RIGHT) != false && this.slot == EntityEquipmentSlot.CHEST);
        boolean bl2 = this.field_178724_i.field_78806_j = (Boolean)ba.get((Object)EnumParts.ARM_LEFT) != false && (!this.isArmorModel || (Boolean)baArmor.get((Object)EnumParts.ARM_LEFT) != false && this.slot == EntityEquipmentSlot.CHEST);
        if (this.field_178723_h.field_78806_j || this.field_178724_i.field_78806_j) {
            if (this.isArmorModel && this.slot == EntityEquipmentSlot.CHEST) {
                stack = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.CHEST);
                this.field_178723_h.field_78806_j = stack.func_77973_b() instanceof ItemArmor && (Boolean)baArmor.get((Object)EnumParts.ARM_RIGHT) != false;
                this.field_178724_i.field_78806_j = stack.func_77973_b() instanceof ItemArmor && (Boolean)baArmor.get((Object)EnumParts.ARM_LEFT) != false;
                ((ModelRendererAlt)this.field_178723_h).clearOBJ();
                ((ModelRendererAlt)this.field_178724_i).clearOBJ();
                if (entityIn instanceof EntityCustomNpc) {
                    boolean smallArms;
                    String m = ((EntityCustomNpc)entityIn).display.getModel();
                    ((ModelRendererAlt)this.field_178723_h).smallArms = smallArms = m != null && m.contains("customnpcalex");
                    ((ModelRendererAlt)this.field_178724_i).smallArms = smallArms;
                }
                if (stack.func_77973_b() instanceof CustomArmor && ((CustomArmor)stack.func_77973_b()).objModel != null) {
                    ((ModelRendererAlt)this.field_178723_h).setOBJModel(stack, null);
                    ((ModelRendererAlt)this.field_178724_i).setOBJModel(stack, null);
                }
            }
            GlStateManager.func_179094_E();
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
            }
            if (this.field_178723_h.field_78806_j) {
                ((ModelRendererAlt)this.field_178723_h).checkBacklightColor(r, g, b);
                if (((ModelRendererAlt)this.field_178723_h).notOBJModel()) {
                    GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
                }
                this.field_178723_h.func_78785_a(scale);
            }
            if (this.field_178724_i.field_78806_j) {
                ((ModelRendererAlt)this.field_178724_i).checkBacklightColor(r, g, b);
                if (((ModelRendererAlt)this.field_178724_i).notOBJModel()) {
                    GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
                }
                this.field_178724_i.func_78785_a(scale);
            }
            GlStateManager.func_179121_F();
        }
        this.field_178721_j.field_78806_j = (Boolean)ba.get((Object)EnumParts.LEG_RIGHT) != false && (!this.isArmorModel || (Boolean)baArmor.get((Object)EnumParts.LEG_RIGHT) != false && (this.slot == EntityEquipmentSlot.LEGS || this.slot == EntityEquipmentSlot.FEET));
        boolean bl3 = this.field_178722_k.field_78806_j = (Boolean)ba.get((Object)EnumParts.LEG_LEFT) != false && (!this.isArmorModel || (Boolean)baArmor.get((Object)EnumParts.LEG_LEFT) != false && (this.slot == EntityEquipmentSlot.LEGS || this.slot == EntityEquipmentSlot.FEET));
        if (((Boolean)ba.get((Object)EnumParts.LEG_RIGHT)).booleanValue() && this.field_178721_j.field_78806_j || ((Boolean)ba.get((Object)EnumParts.LEG_LEFT)).booleanValue() && this.field_178722_k.field_78806_j) {
            boolean legsRender = true;
            if (this.isArmorModel && (this.slot == EntityEquipmentSlot.LEGS || this.slot == EntityEquipmentSlot.FEET)) {
                if (this.slot == EntityEquipmentSlot.LEGS) {
                    this.field_178721_j.field_78806_j = (Boolean)baArmor.get((Object)EnumParts.LEG_RIGHT);
                    this.field_178722_k.field_78806_j = (Boolean)baArmor.get((Object)EnumParts.LEG_LEFT);
                } else {
                    this.field_178721_j.field_78806_j = (Boolean)baArmor.get((Object)EnumParts.FEET_RIGHT);
                    this.field_178722_k.field_78806_j = (Boolean)baArmor.get((Object)EnumParts.FEET_LEFT);
                    baArmor.put((Object)EnumParts.LEG_RIGHT, this.field_178721_j.field_78806_j);
                    baArmor.put((Object)EnumParts.LEG_LEFT, this.field_178722_k.field_78806_j);
                }
                legsRender = ((EntityLivingBase)entityIn).func_184582_a(this.slot).func_77973_b() instanceof ItemArmor;
                ((ModelRendererAlt)this.field_78115_e).clearOBJ();
                ((ModelRendererAlt)this.field_178721_j).clearOBJ();
                ((ModelRendererAlt)this.field_178722_k).clearOBJ();
                if (this.slot == EntityEquipmentSlot.FEET && legsRender && (stack = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.FEET)).func_77973_b() instanceof CustomArmor && ((CustomArmor)stack.func_77973_b()).objModel != null) {
                    if (this.field_178721_j.field_78806_j) {
                        ((ModelRendererAlt)this.field_178721_j).checkBacklightColor(r, g, b);
                        ((ModelRendererAlt)this.field_178721_j).setOBJModel(stack, EnumParts.FEET_RIGHT);
                        this.field_178721_j.func_78785_a(scale);
                    }
                    if (this.field_178722_k.field_78806_j) {
                        ((ModelRendererAlt)this.field_178722_k).checkBacklightColor(r, g, b);
                        ((ModelRendererAlt)this.field_178722_k).setOBJModel(stack, EnumParts.FEET_LEFT);
                        this.field_178722_k.func_78785_a(scale);
                    }
                }
                if (this.slot == EntityEquipmentSlot.LEGS && legsRender && (stack = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.LEGS)).func_77973_b() instanceof CustomArmor && ((CustomArmor)stack.func_77973_b()).objModel != null) {
                    if (this.field_178721_j.field_78806_j) {
                        ((ModelRendererAlt)this.field_178721_j).setOBJModel(stack, null);
                    }
                    if (this.field_178722_k.field_78806_j) {
                        ((ModelRendererAlt)this.field_178722_k).setOBJModel(stack, null);
                    }
                    if (((Boolean)ba.get((Object)EnumParts.BODY)).booleanValue() && this.field_78115_e.field_78806_j) {
                        ((ModelRendererAlt)this.field_78115_e).checkBacklightColor(r, g, b);
                        ((ModelRendererAlt)this.field_78115_e).setOBJModel(stack, EnumParts.BELT);
                        this.field_78115_e.func_78785_a(scale);
                    }
                }
            }
            if (legsRender) {
                GlStateManager.func_179094_E();
                if (entityIn.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.4f, (float)0.0f);
                    if (this.isArmorModel && this.slot == EntityEquipmentSlot.FEET) {
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
                    }
                }
                if (this.field_178721_j.field_78806_j) {
                    ((ModelRendererAlt)this.field_178721_j).checkBacklightColor(r, g, b);
                    if (((ModelRendererAlt)this.field_178721_j).notOBJModel()) {
                        GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
                    }
                    this.field_178721_j.func_78785_a(scale);
                }
                if (this.field_178722_k.field_78806_j) {
                    ((ModelRendererAlt)this.field_178722_k).checkBacklightColor(r, g, b);
                    if (((ModelRendererAlt)this.field_178722_k).notOBJModel()) {
                        GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
                    }
                    this.field_178722_k.func_78785_a(scale);
                }
                GlStateManager.func_179121_F();
            }
        }
        boolean bl4 = this.field_78115_e.field_78806_j = (Boolean)ba.get((Object)EnumParts.BODY) != false && (!this.isArmorModel || (Boolean)baArmor.get((Object)EnumParts.BODY) != false && this.slot == EntityEquipmentSlot.CHEST);
        if (this.field_78115_e.field_78806_j) {
            if (this.isArmorModel) {
                ((ModelRendererAlt)this.field_78115_e).clearOBJ();
                stack = ((EntityLivingBase)entityIn).func_184582_a(EntityEquipmentSlot.CHEST);
                if (stack.func_77973_b() instanceof CustomArmor && ((CustomArmor)stack.func_77973_b()).objModel != null) {
                    ((ModelRendererAlt)this.field_78115_e).setOBJModel(stack, null);
                }
            }
            GlStateManager.func_179094_E();
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
            }
            ((ModelRendererAlt)this.field_78115_e).checkBacklightColor(r, g, b);
            if (((ModelRendererAlt)this.field_78115_e).notOBJModel()) {
                GL11.glBindTexture((int)3553, (int)entitySkinTextureID);
            }
            this.field_78115_e.func_78785_a(scale);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private boolean renderHead(EntityLivingBase living, float scale) {
        ItemStack stack = living.func_184582_a(EntityEquipmentSlot.HEAD);
        ((ModelRendererAlt)this.field_78116_c).clearOBJ();
        if (stack.func_77973_b() instanceof CustomArmor && ((CustomArmor)stack.func_77973_b()).objModel != null) {
            ((ModelRendererAlt)this.field_78116_c).setOBJModel(stack, null);
        }
        this.field_78116_c.func_78785_a(scale);
        return ((ModelRendererAlt)this.field_78116_c).notOBJModel();
    }

    public void setSlot(EntityEquipmentSlot slotIn) {
        this.slot = slotIn;
    }

    public void setArmorColor(float r, float g, float b) {
        this.armorColorR = r;
        this.armorColorG = g;
        this.armorColorB = b;
    }
}

